<!DOCTYPE html>
<html lang="en" dir="ltr">
  <head>
    <meta charset="utf-8">
    <title>Contiinued | Admin</title>

    <script src="https://kit.fontawesome.com/08df1faba4.js" crossorigin="anonymous"></script>

    <!-- cntd.js -->
    <script src="<?= URLROOT ?>/js/cntdjs/jquery.js"></script>
    <script src="<?= URLROOT ?>/js/cntdjs/cntd.js"></script>

    <!-- shared stylesheets -->
    <link rel="stylesheet" href="<?= URLROOT ?>/css/shared/bootstrap.css">
    <link rel="stylesheet" href="<?= URLROOT ?>/css/shared/media-queries.css">
    <link rel="stylesheet" href="<?= URLROOT ?>/css/shared/animations.css">
    <link rel="stylesheet" href="<?= URLROOT ?>/css/shared/common.css">
    <link rel="stylesheet" href="<?= URLROOT ?>/css/shared/loading-display.css">
    <link rel="stylesheet" href="<?= URLROOT ?>/css/shared/form.css">
  </head>
  <body>
    <!-- Loading Display -->
    <div id="loading-display">
      <img id="loading-display-icon" src="<?= URLROOT ?>/img/installation/logo-clear.png">
    </div>

    <div class="nav-bar">
      <div class="nav-block">
        <img id="nav-bar-logo" src="<?= URLROOT ?>/img/installation/logo-clear.png">
      </div>
      <div class="nav-block">
        <p id="active-page">Configuration</p>
      </div>
    </div>
    <div class="container">
      <div class="widget-box installation-box" id="blue-left-border">
        <h1>Panel Login</h1>
        <div id="divider"></div>
        <p>Thank you for choosing <span id="monospaced">@contiinued</span></p>
      </div>

      <br>

      <div class="widget-box installation-box" id="green-left-border">
        <p>Please login using the credentials you set during installation.</p>

        <form class="cntd-form" id="login-form" action="<?= URLROOT ?>/user/login" method="POST">
          <?php $helper = new ErrorHelper(); $helper->handle_html_error($data); ?>
          <p class="error-message"><b>Input Error:</b> one or more of the fields below are empty, please try again.</p>


          <div class="input-section">
            <label class="cntd-label">Username:</label>
            <input type="text" id="username" name="username" class="cntd-input" onkeydown="sanitise_username(event)">
          </div>

          <br>

          <div class="input-section">
            <label class="cntd-label">Password:</label>
            <input type="password" id="password" name="password" class="cntd-input">
          </div>

        </form>

      </div>

      <br>

      <div class="widget-box installation-box" id="navy-left-border">
        <button type="button" onclick="$('#login-form').submit()" class="big-button" id="login-button">LOG IN</button>
      </div>
    </div>

    <!-- Tooltips -->
    <script src="https://unpkg.com/@popperjs/core@2/dist/umd/popper.min.js"></script>
    <script src="https://unpkg.com/tippy.js@6/dist/tippy-bundle.umd.js"></script>

    <!-- Shared Scripts -->
    <script src="<?= URLROOT ?>/js/shared/display_functions.js"></script>
    <script src="<?= URLROOT ?>/js/shared/configure_tooltips.js"></script>

    <!-- Page Specific Scripts -->
    <script src="<?= URLROOT ?>/js/login/login_functions.js"></script>
    <script src="<?= URLROOT ?>/js/login/login.js"></script>
    <script> hide_loading(); </script>
  </body>
</html>
