<!DOCTYPE html>
<html lang="en" dir="ltr">
  <head>
    <meta charset="utf-8">
    <title>Contiinued | Admin</title>

    <script src="https://kit.fontawesome.com/08df1faba4.js" crossorigin="anonymous"></script>

    <!-- cntd.js -->
    <script src="<?= URLROOT ?>/js/cntdjs/jquery.js"></script>
    <script src="<?= URLROOT ?>/js/cntdjs/jquery.mask.js"></script>
    <script src="<?= URLROOT ?>/js/cntdjs/cntd.js"></script>

    <!-- shared stylesheets -->
    <link rel="stylesheet" href="<?= URLROOT ?>/css/shared/bootstrap.css">
    <link rel="stylesheet" href="<?= URLROOT ?>/css/shared/common.css">
    <link rel="stylesheet" href="<?= URLROOT ?>/css/shared/form.css">
    <link rel="stylesheet" href="<?= URLROOT ?>/css/shared/media-queries.css">
    <link rel="stylesheet" href="<?= URLROOT ?>/css/shared/loader.css">

    <!-- external stylesheets -->
    <link rel="stylesheet" href="<?= URLROOT ?>/css/libraries/growl-notification/jquery.growl.css">

    <!-- page specific stylesheets -->
    <link rel="stylesheet" href="<?= URLROOT ?>/css/dashboard/entries.css">
    <link rel="stylesheet" href="<?= URLROOT ?>/css/dashboard/admin-settings-modal.css">
    <script src="<?= URLROOT ?>/js/dashboard/dashboard_functions.js"></script>

    <script>
    var audio = new Audio('<?= URLROOT ?>/sfx/panel-alert.mp3');
    audio.loop = true;
    </script>
  </head>
  <body>

    <div class="modal-overlay visitor-click-details-modal" id="modal-overlay" style="display: none">
      <div class="modal-box">
        <div class="row" id="full-height" style="padding: 10px;">
          <div class="col-12" style="position: relative">
            <div class="modal-content-container">
              <div class="modal-content-title">
                Clicked Visitor Details
              </div>

              <div id="divider"></div>

              <div id="visitor-click-list" style="color: white; overflow: scroll; max-height: 400px;">

              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="modal-overlay admin-settings-modal" id="modal-overlay" style="display: none">
      <div class="modal-box">
        <div class="row" id="full-height">
          <div class="col-3">
            <div class="modal-side-nav-bar">
              <div class="modal-side-nav-bar-title">Settings</div>
              <div class="modal-side-nav-bar-link active" linked_to="add_user_account">Add User Account</div>
              <div class="modal-side-nav-bar-link" linked_to="manage_user_accounts">Manage User Accounts</div>
            </div>
          </div>
          <div class="col-9" style="position: relative">
            <div class="modal-content-container admin-modal-content-container" id="add_user_account">
              <div class="modal-content-title">
                Add User Account
              </div>

              <div id="divider"></div>

              <p>Add a subordinate user account below. Each username must be unique.</p>

              <p class="error-message empty-field-error"><b>Input Error:</b> one or more of the fields below are empty, please try again.</p>
              <p class="error-message user-add-error"><b>Error:</b> there was an error while attempting to create account, please ensure the username is unique.</p>
              <p class="success-message user-add-success"><b>Success:</b> the account was successfully added.</p>

              <form id="add-user-form">
                <div class="form-group full-width">
                  <label class="cntd-label">Username</label>
                  <input  name="username" id="username" type="text" class="cntd-input full-width" onkeydown="sanitise_username(event)" style="width: 100% !important;">
                </div>

                <div class="form-group">
                  <label class="cntd-label">Password</label>
                  <input name="password" id="password" type="password" class="cntd-input full-width" style="width: 100% !important;">
                </div>

                <div class="form-group">
                  <input type="submit" class="cntd-btn" style="width: 100% !important;">
                </div>
              </form>
            </div>

            <div class="modal-content-container hidden" id="manage_user_accounts">
              <div class="modal-content-title">
                Manage User Accounts
              </div>

              <div id="divider"></div>

              <p>View and manage all the user accounts here.</p>

              <p class="error-message user-row-deletion-error"><b>Deletion Error:</b> the deletion attempt failed.</p>
              <p class="success-message user-row-deletion-success"><b>Success:</b> the account was successfully deleted.</p>

              <div class="user-account-table-container">
                <div class="user-account-table-header">
                  <div class="row">
                    <div class="col-12">
                      <div class="user-account-table-header-text">USERNAME</div>
                    </div>
                  </div>
                </div>

                <div loaded_content="admin_user_table_rows"></div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="nav-bar">
      <div class="nav-block">
        <img id="nav-bar-logo" src="<?= URLROOT ?>/img/installation/logo-clear.png">
      </div>
      <div class="nav-block">
        <p id="active-page">Dashboard</p>
      </div>
      <div class="nav-block icon-box" id="right">
        <a href="<?= URLROOT ?>/user/logout" class="icon"><i id="sign-out-icon" class="fas fa-sign-out-alt"></i></a>
      </div>
      <?php $helper = new ErrorHelper(); $helper->handle_admin_setting_icon($data); ?>
      <div class="nav-block" id="right">
        <p id="active-page" <?php if ($data["is_user_admin"] == 'true') { echo 'style="color: rgb(220, 50, 50)"'; }?>><?= $data["username"] ?></p>
      </div>
    </div>

    <div class="container">
      <!-- Start Top Widget Bar -->
      <div class="row">
        <div class="col-12 col-lg-4">
          <div class="widget-box" id="blue-left-border">
            <p onclick="display_visitor_click_details()">Clicks</p>
            <span class="widget-content" id="visitor-click-count-text">...</span>
            <div class="clear"></div>
          </div>
        </div>
        <div class="col-12 col-lg-4">
          <div class="widget-box" id="green-left-border">
            <p>Visitors</p>
            <span class="widget-content" id="visitor-count-text">...</span>
            <div class="clear"></div>
          </div>
        </div>
        <div class="col-12 col-lg-4">
          <div class="widget-box" id="navy-left-border">
            <p>Elapsed time</p>
            <span class="widget-content" id="elapsed-time-text">...</span>
            <div class="clear"></div>
          </div>
        </div>
      </div>
      <!-- End Top Widget Bar -->

      <!-- Start Victim Rows -->
      <div class="row">
        <div class="col-lg-8">
          <div class="entries-box">
            <!-- Print users here onload so there is no empty table if loading is prolonged -->
            <div><br><div class="loader"></div><br></div>
          </div>
        </div>
        <div class="col-lg-4">
          <div class="filter-window">
            <p><b>FILTER</b><span onclick="hide_filter_window()" class="preview-filter-btn"><i class="fas fa-times"></i></span></p>

            <form class="preview-filter-box"></form>
          </div>
          <div class="entry-preview-box">
            <span class="entry-preview-title">Preview <span onclick="show_filter_window()" class="preview-filter-btn"><i class="fas fa-cog"></i></span></span>


            <div class="entry-information-box"><div class="entry">Nothing Selected!</div></div>

            <div class="entry-action-box">
              <div class="row">
                <?php $data["option_builder"]->build_options(); ?>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-- End Victim Rows -->
    </div>

    <!-- Hidden Information  -->
    <form>
      <input type="hidden" name="previous_entry_uniqueid">
      <input type="hidden" name="selected_visitor_uniqueid">
    </form>

    <!-- Shared Scripts -->
    <script src="<?= URLROOT ?>/js/shared/display_functions.js"></script>
    <script src="<?= URLROOT ?>/js/libraries/growl-notification/jquery.growl.js"></script>
    <script src="<?= URLROOT ?>/js/shared/notification_functions.js"></script>

    <!-- Page Specific Scripts -->
    <script>var urlroot = '<?= URLROOT ?>';</script>
    <script src="<?= URLROOT ?>/js/dashboard/admin-settings-modal.js"></script>
    <script src="<?= URLROOT ?>/js/dashboard/preview-box.js"></script>

    <script src="<?= URLROOT ?>/js/dashboard/visitor-table.js"></script>
    <script src="<?= URLROOT ?>/js/dashboard/dashboard.js"></script>
    <script src="<?= URLROOT ?>/js/dashboard/preview-filter.js"></script>
    <script>
    // 1s delay to sync with the visitor row loading
    setInterval(function() { load_selected_visitor_uniqueid_if_saved(); }, 1000);

    // loads the preview fitler
    load_preview_filter();

    function copy(element) {
      var temp_input = $('<input>');
      $('body').append(temp_input);
      $(element).css("color", "darkgray");
      temp_input.val($(element).text()).select();
      document.execCommand("copy");
      temp_input.remove();
    }
    </script>
  </body>
</html>
