<?php
class RequestHelper {
  protected function refuse_access() {
    http_response_code(405);
    die(0);
  }

  public function only_allow_post_request() {
    if ($_SERVER["REQUEST_METHOD"] != "POST") {
      http_response_code(405);
      die(0);
    }
  }

  public function only_allow_get_request() {
    if ($_SERVER["REQUEST_METHOD"] != "GET") {
      http_response_code(405);
      die(0);
    }
  }

  public function only_allow_ajax_call() {
    if (!isset($_SERVER["HTTP_X_REQUESTED_WITH"]) || (empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) != 'xmlhttprequest')) {
      http_response_code(405);
      die(0);
    }
  }

  public function is_logged_in_user_admin($user_model) {
    if (!isset($_SESSION["active_user_username"])) { return; }
    $active_user_username = $_SESSION["active_user_username"];

    return $user_model->is_user_admin($active_user_username) == "true";
  }

  public function must_include_variables($expected_variables) {
    foreach ($expected_variables as $variable) {
      if (!isset($variable) || empty($variable) ) { http_response_code(500); die(0); }
    }
  }

  public function send_json_response($action) {
    $success_message = $action ? 'true' : 'false';

    echo json_encode(array('status' => $success_message));
  }

  public function json_from_array($array) {
    echo json_encode($array);
    die(0);
  }
}
?>
