<?php
class User extends Controller {
  protected $user_model;

  public function __construct() {
    Controller::__construct();
    $this->user_model = $this->model("UserModel");

    // sets project wide session variable containing this
    $_SESSION["page_name_to_status_array"] = $this->get_status_to_name_array();
  }

  // parses options.json and changes to array with status as key and page name as value
  public function get_status_to_name_array() {
    $options = json_decode(file_get_contents("../app/config/options.json"), true);
    $comp = array();

    foreach ($options as $option) {
      $buttons = $option["buttons"];

      foreach ($buttons as $button) {
        $comp[$button["status"]] = $button["name"];
      }
    }

    return $comp;
  }

  public function index() {
    $this->installation_helper->must_be_installed();
    if ($this->user_model->is_user_logged_in()) { $this->redirection_helper->send_to_dashboard(); die(0); }

    header("Location: " . URLROOT . "/user/login");
  }

  public function login() {
    $this->installation_helper->must_be_installed();

    // attempt_login is called here to keep url ending in /login
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
      $this->attempt_login();
      die(0);
    }

    if ($this->user_model->is_user_logged_in()) { $this->redirection_helper->send_to_dashboard(); die(0); }
    $this->view("user/login");
  }

  protected function attempt_login() {
    $this->request_helper->only_allow_post_request();
    // add must_include_variables

    $login_attempt = $this->user_model->verify_user_login($_POST["username"], $_POST["password"]);
    $this->error_helper->check_action($this, $login_attempt, "user/login", "incorrect_login");

    $this->user_model->begin_login_session();
    $this->user_model->set_active_user_username($_POST["username"]);
    $this->redirection_helper->send_to_dashboard();
  }

  public function add_user() {
    $this->request_helper->only_allow_post_request();
    $this->request_helper->only_allow_ajax_call();
    $this->request_helper->must_include_variables(array($_POST["username"], $_POST["password"]));
    if (!$this->is_user_admin()) { echo json_encode(array('false')); return; }

    $account_creation_attempt = $this->user_model->add_user($_POST["username"], $_POST["password"], 0);
    $this->request_helper->send_json_response($account_creation_attempt);
  }

  public function display_users() {
    $this->request_helper->only_allow_ajax_call();
    $this->request_helper->only_allow_get_request();

    $get_all_users = $this->user_model->get_all_users();
    $table_rows = "";
    $user_table_row_template_path = "../app/views/dashboard/templates/manage-user-table-row.html";
    $empty_user_table_template_path = "../app/views/dashboard/templates/empty-user-table.html";

    if (count($get_all_users) == 0) { echo $this->element_helper->get_template($empty_user_table_template_path); return; }

    foreach ($get_all_users as $index=>$user) {
      $is_alternate = $index % 2 == 0 ? 'user-account-table-alternate-row' : '';

      $fields_to_replace = array("{username}", "{is_alternate}");
      $replaced_field_content = array($user["username"], $is_alternate);

      $table_rows .= $this->element_helper->construct_template($user_table_row_template_path, $fields_to_replace, $replaced_field_content);
    }

    echo $table_rows;
  }

  public function delete_user() {
    $this->request_helper->only_allow_ajax_call();
    $this->request_helper->only_allow_post_request();
    if (!$this->is_user_admin()) { echo json_encode(array('false')); return; }

    $user_deletion_attempt = $this->user_model->delete_user($_POST["username"]);
    $this->request_helper->send_json_response($user_deletion_attempt);
  }

  public function is_user_admin() {
    if (!isset($_SESSION["active_user_username"])) { return; }
    $active_user_username = $_SESSION["active_user_username"];

    return $this->user_model->is_user_admin($active_user_username) == 'true';
  }

  public function logout() {
    $this->user_model->end_login_session();
    header("Location: " . URLROOT . "/user/login");
    die(0);
  }
}
 ?>
